% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackmds.smacofP.R
\name{jackmds.smacofP}
\alias{jackmds.smacofP}
\title{MDS Jackknife for smacofP objects}
\usage{
\method{jackmds}{smacofP}(object, eps = 1e-06, itmax = 100, verbose = FALSE)
}
\arguments{
\item{object}{Object of class smacofP if used as method or another object inheriting from smacofB (needs to be called directly as jackmds.smacofP then).}

\item{eps}{Convergence criterion}

\item{itmax}{Maximum number of iterations}

\item{verbose}{If 'TRUE', intermediate stress is printed out.}
}
\value{
An object of class 'smacofJK', see \code{\link[smacof]{jackmds}}. With values 
\itemize{
\item smacof.conf: Original configuration
\item jackknife.confboot: An array of n-1 configuration matrices for each Jackknife MDS solution
\item comparison.conf: Centroid Jackknife configurations (comparison matrix)
\item cross: Cross validity
\item stab: Stability coefficient
\item disp: Dispersion
\item loss: Value of the loss function (just used internally)
\item ndim: Number of dimensions
\item call: Model call
\item niter: Number of iterations
\item nobj: Number of objects
}
}
\description{
These functions perform an MDS Jackknife and plot the corresponding solution.
}
\details{
In order to examine the stability solution of an MDS, a Jackknife on the configurations can be performed (see de Leeuw & Meulman, 1986) and plotted. The plot shows the jackknife configurations which are connected to their centroid. In addition, the original configuration (transformed through Procrustes) is plotted. The Jackknife function itself returns also a stability measure (as ratio of between and total variance), a measure for cross validity, and the dispersion around the original smacof solution.
}
\examples{
dats <- na.omit(smacof::PVQ40[,1:5])
diss <- dist(t(dats))   ## Euclidean distances
fit <- rStressMin(diss,type="ordinal",r=0.4,itmax=1000) ## 2D ordinal MDS

res.jk <- jackmds(fit)
plot(res.jk, col.p = "black", col.l = "gray")
plot(res.jk, hclpar = list(c = 80, l = 40))
plot(res.jk, hclpar = list(c = 80, l = 40), plot.lines = FALSE)
}
