%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.qqline}

\alias{plot.qqline}

\title{Add Line Going Through the Quantiles of a Q-Q Plot}

\description{
This function adds a line to a quantile-quantile plot which passes
through user defined quantiles. This function is similar to, but
more general than, \code{\link{qqline}} because the reference
distribution need not be the standard normal distribution and the
quantiles need not be the first and third quartiles. \cr 
Graphical parameters may be given as arguments to \code{plot.qqline}. 
}

\usage{
plot.qqline(x, y, a=0.25, ...)
}

\arguments{
\item{x}{the reference (first) sample for the Q-Q plot, for a normal Q-Q
  plot this would be the quantiles of a N(0,1) random sample.}
\item{y}{the data.}
\item{a}{a number between 0 and 1. A line is drawn which connects the
  \code{a} and \code{1-a} quantile points. The default line passes
  through the first and third quantiles.}
 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see \code{\link{par}}).} 
}

\seealso{\code{\link{qqplot}}, \code{\link{qqnorm}}, \code{\link{qqline}}.  }

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
# mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Calculation of t-statistics
## cl <- c(rep(1,3), rep(2,3))
## mouse.t2 <- stat.t2(mouse.lratio, cl)

## Diagnostic plots
plot.qq(mouse.t2$t, "Mouse")

## Using the QQline function
q <- quantile(rnorm(1000))
plot.qqline(q, mouse.t2$t)
}    


\keywords{aplot}

%\keyword{Q-Q plots, quartiles}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
