% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Slurm_log.R
\name{Slurm_log}
\alias{Slurm_log}
\title{Check the R logfile of a job.}
\usage{
Slurm_log(x, which. = NULL, cmd = NULL)
}
\arguments{
\item{x}{An object of class \link{slurm_job}.}

\item{which.}{An integer scalar. The number of the array job to check. This
should range between 1 and \code{x$njobs}.}

\item{cmd}{Character scalar. The name of the command to use to call view the
log file. Default to \code{less} when interactive mode, otherwise \code{cat} (see details).}
}
\value{
Whatever the command-line call returns.
}
\description{
After submission, the functions of type \link[=Slurm_lapply]{Slurm_*apply} generate
log files, one per each job in the job array. The \code{Slurm_log} function can be
used to check the log files of jobs in the array that failed.
}
\details{
If other than \code{less} is used, then the function will try to
check by calling \code{cmd --version}. If returns with error, it assumes the
function is not available. Using the \code{cmd} argument only works in interactive
mode.
}
\examples{
\dontrun{
x <- Slurm_EvalQ(slurmR::whoami(), plan = "wait")
Slurm_log(x) # Checking the R log
}
}
\seealso{
Other post submission: 
\code{\link{Slurm_clean}()},
\code{\link{Slurm_collect}()},
\code{\link{status}()}

Other utilities: 
\code{\link{Slurm_clean}()},
\code{\link{Slurm_env}()},
\code{\link{WhoAmI}()},
\code{\link{parse_flags}()},
\code{\link{snames}()},
\code{\link{status}()}
}
\concept{post submission}
\concept{utilities}
