% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Slurm_clean}
\alias{Slurm_clean}
\title{Clean a session.}
\usage{
Slurm_clean(x)
}
\arguments{
\item{x}{An object of class \code{slurm_job}.}
}
\description{
The functions of the family \link[=Slurm_lapply]{Slurm_*apply} generate a set of
temporary files that are used for the job design, submission and collection.
This function will remove all the contents of directory created by calling
those functions.
}
\details{
If the job is finalized, it returns 0 if able to clean the directory
otherwise return whatever \link{unlink} returns after trying to remove the job
path.
}
\examples{
\dontrun{

job <- Slurm_EvalQ(1 + 1, 2, plan = "collect")

# This will remove all the files generated by Slurm_EvalQ
Slurm_clean(job)

}
}
\seealso{
Other post submission: 
\code{\link{Slurm_collect}()},
\code{\link{Slurm_log}()},
\code{\link{status}()}

Other utilities: 
\code{\link{Slurm_env}()},
\code{\link{Slurm_log}()},
\code{\link{WhoAmI}()},
\code{\link{parse_flags}()},
\code{\link{snames}()},
\code{\link{status}()}
}
\concept{post submission}
\concept{utilities}
