% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{metadata_lscape}
\alias{metadata_lscape}
\title{download SLGA landscape metadata}
\usage{
metadata_lscape(product = NULL, req_type = "desc", format = "native")
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}, where 'Type' =
'Landscape'.}

\item{req_type}{Character; one of 'cap' or 'desc'. Defaults to 'desc'.}

\item{format}{Character; one of 'xml' or 'native'. Defaults to 'native'.}
}
\value{
A list or xml document object, depending on the value of 'format'.
}
\description{
Retrieves metadata from Soil and Landscape Grid of Australia landscape WCS
endpoints in XML or list format.
}
\note{
Parameter `product` is optional for `req_type = 'desc'`, leave out to
  get metadata for all available landscape products.
}
\examples{
\donttest{
 slp_md <- slga::metadata_lscape('SLPPC', format = 'native')
 }
}
