% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_dev.R
\name{slackr_dev}
\alias{slackr_dev}
\title{Send the graphics contents of the current device to a Slack channel}
\usage{
slackr_dev(
  channels = Sys.getenv("SLACK_CHANNEL"),
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN"),
  plot_text = "",
  file = "plot"
)
}
\arguments{
\item{channels}{list of channels to post image to}

\item{bot_user_oauth_token}{the Slack full bot user OAuth token (chr)}

\item{plot_text}{the plot text to send with the plot (defaults to "")}

\item{file}{prefix for filenames (defaults to \code{plot})}
}
\value{
\code{httr} response object from \code{POST} call
}
\description{
\code{slackr_dev} sends the graphics contents of the current device to the
specified Slack channel.
}
\examples{
\dontrun{
slackr_setup()

# base
library(maps)
map("usa")
slackr_dev("#results", file = "map")

# base
barplot(VADeaths)
slackr_dev("@jayjacobs")
}
}
\references{
\url{https://github.com/mrkaye97/slackr/pull/12/files}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}, \code{\link[=slackr_save]{slackr_save()}}, \code{\link[=slackr_upload]{slackr_upload()}}
}
\author{
Konrad Karczewski (ctb), Bob Rudis (aut)
}
