% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{spark_bar}
\alias{spark_bar}
\title{Draw a sparkline bar graph with unicode block characters}
\usage{
spark_bar(x, safe = TRUE)
}
\arguments{
\item{x}{A numeric vector between 0 and 1}

\item{safe}{Nominally there are 8 block elements from 1/8 height to full
height (8/8). However, the half-height and full-height blocks appear
to be rendered inconsistently (possibly due to font substitution).}
}
\description{
Rendered using [block elements](https://en.wikipedia.org/wiki/Block_Elements).
In most common fixed width fonts these are rendered wider than regular
characters which means they are not suitable if you need precise alignment.
}
\examples{
\dontrun{
x <- seq(0, 1, length = 6)
spark_bar(x)
spark_bar(sample(x))

# This might work if you're lucky
spark_bar(seq(0, 1, length = 8), safe = FALSE)

spark_bar(c(0, NA, 0.5, NA, 1))
}
}
