% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_packages.R
\name{load_packages}
\alias{load_packages}
\title{Install and load packages}
\usage{
load_packages(packages, quite = FALSE, upgrade.deps = FALSE)
}
\arguments{
\item{packages}{Character vector with the names of the packages to be installed. The vector names indicate the repositories from which packages will be installed. If no name is included CRAN will be used as the default repository. Available repostories are: 'cran', 'github', 'gitlab', 'bitbucket' and 'bioconductor'. Note that for 'github', 'gitlab' and 'bitbucket' the string must include the user name in the form 'user/package'.}

\item{quite}{Logical argument to control if package startup messages are printed. Default is \code{FALSE} (messages are printed).}

\item{upgrade.deps}{Logical argument to control if package dependecies are upgraded.Default is \code{FALSE}.}
}
\value{
No object is returned.
}
\description{
\code{load_packages} installs and loads packages from different repositories.
}
\details{
The function installs and loads packages from different repositories.
}
\examples{
\dontrun{
load_packages(packages = c("kableExtra", bioconductor = "ggtree",
github = "maRce10/Rraven"), quite = TRUE)
}

}
\references{
{
Araya-Salas, M., Willink, B., Arriaga, A. (2020), sketchy: research compendiums for data analysis in R. R package version 1.0.2.
}
}
\seealso{
\code{\link{compendiums}}, \code{\link{make_compendium}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
