% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_var.R
\name{find_var}
\alias{find_var}
\title{Find variable by name or label}
\usage{
find_var(data, pattern, ignore.case = TRUE, search = c("name_label",
  "name_value", "label_value", "name", "label", "value", "all"),
  out = c("table", "df", "index"), fuzzy = FALSE, regex = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{pattern}{Character string to be matched in \code{data}. May also be a
character vector of length > 1 (see 'Examples'). \code{pattern} is
searched for in column names and variable label attributes of
\code{data} (see \code{\link[sjlabelled]{get_label}}). \code{pattern}
might also be a regular-expression object, as returned by \code{\link[stringr]{regex}}.
Alternatively, use \code{regex = TRUE} to treat \code{pattern} as a regular
expression rather than a fixed string.}

\item{ignore.case}{Logical, whether matching should be case sensitive or not.}

\item{search}{Character string, indicating where \code{pattern} is sought.
Use one of following options:
\describe{
  \item{\code{"name_label"}}{The default, searches for \code{pattern} in
        variable names and variable labels.}
  \item{\code{"name_value"}}{Searches for \code{pattern} in
        variable names and value labels.}
  \item{\code{"label_value"}}{Searches for \code{pattern} in
        variable and value labels.}
  \item{\code{"name"}}{Searches for \code{pattern} in
        variable names.}
  \item{\code{"label"}}{Searches for \code{pattern} in
        variable labels}
  \item{\code{"value"}}{Searches for \code{pattern} in
        value labels.}
  \item{\code{"all"}}{Searches for \code{pattern} in
        variable names, variable and value labels.}
}}

\item{out}{Output (return) format of the search results. May be abbreviated
and must be one of:
\describe{
  \item{\code{"table"}}{A tabular overview (as data frame) with
    column indices, variable names and labels of matching variables.
  }
  \item{\code{"df"}}{A data frame with all matching variables.}
  \item{\code{"index"}}{
    A named vector with column indices of all matching variables.
  }
}}

\item{fuzzy}{Logical, if \code{TRUE}, "fuzzy matching" (partial and
close distance matching) will be used to find \code{pattern}
in \code{data} if no exact match was found.}

\item{regex}{Logical, if \code{TRUE}, \code{pattern} is treated as a regular
expression rather than a fixed string.}
}
\value{
By default (i.e. \code{out = "table"}, returns a data frame with three
        columns: column number, variable name and variable label. If
        \code{out = "index"}, returns a named vector with column indices
        of matching variables (variable names are used as names-attribute);
        if \code{out = "df"}, returns the matching variables as data frame
}
\description{
This functions finds variables in a data frame, which variable
               names or variable (and value) label attribute match a specific
               pattern. Regular expression for the pattern is supported.
}
\details{
This function searches for \code{pattern} in \code{data}'s column names
           and - for labelled data - in all variable and value labels of \code{data}'s
           variables (see \code{\link[sjlabelled]{get_label}} for details on variable labels and
           labelled data). Regular expressions are supported as well, by simply using
           \code{pattern = stringr::regex(...)} or \code{regex = TRUE}.
}
\examples{
data(efc)

# find variables with "cop" in variable name
find_var(efc, "cop")

# return data frame with matching variables
find_var(efc, "cop", out = "df")

# or return column numbers
find_var(efc, "cop", out = "index")

# find variables with "dependency" in names and variable labels
library(sjlabelled)
find_var(efc, "dependency")
get_label(efc$e42dep)

# find variables with "level" in names and value labels
res <- find_var(efc, "level", search = "name_value", out = "df")
res
get_labels(res, attr.only = FALSE)

# use sjPlot::view_df() to view results
\dontrun{
library(sjPlot)
view_df(res)}

}
