% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_note.R
\name{set_note}
\alias{set_note}
\alias{set_note<-}
\title{Add notes (annotations) to (labelled) variables}
\usage{
set_note(x, value = NULL)

set_note(x) <- value
}
\arguments{
\item{x}{Variable (vector).}

\item{value}{The note (annotation) as character string that will be added as
\code{note}-attribute to \code{x}.}
}
\value{
\code{x}, with \code{value} stored as attribute.
}
\description{
This function adds a note (string) as \code{note}-attribute
               to \code{x}.
}
\examples{
library(haven)
# create labelled factor
x <- labelled(c("M", "M", "F", "X", "N/A"),
              c(Male = "M", Female = "F",
                Refused = "X", "Not applicable" = "N/A"))

set_label(x) <- "A labelled vector with note"
set_note(x) <- "Test annotation."
get_note(x)
x

}
