% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_value.R
\name{to_value}
\alias{to_value}
\title{Convert factors to numeric variables}
\usage{
to_value(x, ..., start.at = NULL, keep.labels = TRUE)
}
\arguments{
\item{x}{\code{\link{factor}} or a data frame with factors. May also be
a character vector.}

\item{...}{Optional, unquoted names of variables. Required, if either
\code{x} is a data frame and no vector, or if only selected variables
from \code{x} should be used in the function. See 'Examples'.}

\item{start.at}{starting index, i.e. the lowest numeric value of the variable's
value range. By default, this argument is \code{NULL}, hence the lowest
value of the returned numeric variable corresponds to the lowest factor
level (if factor is \code{\link{numeric}}) or to \code{1} (if factor levels
are not numeric).}

\item{keep.labels}{logical, if \code{TRUE}, former factor levels will be added as
value labels. For numeric factor levels, values labels will be used,
if present. See 'Examples' and \code{\link{set_labels}} for more details.}
}
\value{
A numeric variable with values ranging either from \code{start.at} to
          \code{start.at} + length of factor levels, or to the corresponding
          factor levels (if these were numeric). Or a data frame with numeric
          variables, if \code{x} was a data frame.
}
\description{
This function converts (replaces) factor values with the
related factor level index number, thus the factor is converted to
a numeric variable.
}
\examples{
data(efc)
test <- to_label(efc$e42dep)
table(test)

table(to_value(test))
hist(to_value(test, start.at = 0))

# set lowest value of new variable to "5".
table(to_value(test, start.at = 5))

# numeric factor keeps values
dummy <- factor(c("3", "4", "6"))
table(to_value(dummy))

# do not drop unused factor levels
dummy <- ordered(c(rep("No", 5), rep("Maybe", 3)),
                 levels = c("Yes", "No", "Maybe"))
to_value(dummy)

# non-numeric factor is converted to numeric
# starting at 1
dummy <- factor(c("D", "F", "H"))
table(to_value(dummy))

# for numeric factor levels, value labels will be used, if present
dummy1 <- factor(c("3", "4", "6"))
set_labels(dummy1) <- c("first", "2nd", "3rd")
dummy1
to_value(dummy1)

# for non-numeric factor levels, these will be used.
# value labels will be ignored
dummy2 <- factor(c("D", "F", "H"))
set_labels(dummy2) <- c("first", "2nd", "3rd")
dummy2
to_value(dummy2)


# easily coerce specific variables in a data frame to numeric
# and keep other variables, with their class preserved
data(efc)
efc$e42dep <- as.factor(efc$e42dep)
efc$e16sex <- as.factor(efc$e16sex)
efc$e17age <- as.factor(efc$e17age)

# convert back "sex" and "age" into numeric
to_value(efc, e16sex, e17age)

}
\seealso{
\code{\link{to_label}} to convert a labelled vector into a factor with labelled
           factor levels and \code{\link{to_factor}} to convert a numeric variable
           into a factor (and preserve labels)
}

