% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc.R
\name{re_var}
\alias{re_var}
\title{Random effect variances}
\usage{
re_var(x)
}
\arguments{
\item{x}{Fitted mixed effects model (\code{\link[lme4]{merMod}}-class).}
}
\value{
\code{NULL}, as this is just a convenient \code{print}-wrapper for
          the variance components returned by the \code{\link{icc}} function.
}
\description{
This function extracts the random effect variances as well as
               the random-intercept-slope-correlation of mixed effects models.
               Currently, only \code{\link[lme4]{merMod}} objects
               are supported.
}
\examples{
library(lme4)
fit1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
re_var(fit1)

sleepstudy$mygrp <- sample(1:45, size = 180, replace = TRUE)
fit2 <- lmer(Reaction ~ Days + (1 | mygrp) + (Days | Subject), sleepstudy)
re_var(fit2)

}
\references{
Aguinis H, Gottfredson RK, Culpepper SA. 2013. Best-Practice Recommendations for Estimating Cross-Level Interaction Effects Using Multilevel Modeling. Journal of Management 39(6): 1490–1528 (\doi{10.1177/0149206313478188})
}
\seealso{
\code{\link{icc}}
}

