% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{to_label}
\alias{to_label}
\title{Converts variable into factor and replaces values with associated value labels}
\usage{
to_label(x)
}
\arguments{
\item{x}{A variable of type \code{\link{numeric}}, \code{\link{atomic}},
\code{\link{factor}} or \code{\link[haven]{labelled}} (see \code{haven} package)
\emph{with associated value labels} (see \code{\link{set_val_labels}}),
respectively a data frame with such variables.}
}
\value{
A factor variable with the associated value labels as factor levels, or a
          data frame with such factor variables (if \code{x} was a data frame).
}
\description{
This function converts (replaces) variable values (also of factors)
               with their associated value labels. Might be helpful for factor variables.
               For instance, if you have a Gender variable with 0/1 value, and associated
               labels are male/female, this function would convert all 0 to male and
               all 1 to female and returns the new variable as \code{\link{factor}}.
}
\note{
Value and variable label attributes (see, for instance, \code{\link{get_val_labels}}
        or \code{\link{set_val_labels}}) will be removed  when converting variables to factors.
}
\examples{
data(efc)
print(get_val_labels(efc)['c161sex'])
head(efc$c161sex)
head(to_label(efc$c161sex))

print(get_val_labels(efc)['e42dep'])
table(efc$e42dep)
table(to_label(efc$e42dep))

head(efc$e42dep)
head(to_label(efc$e42dep))

# structure of numeric values won't be changed
# by this function, it only applies to labelled vectors
# (typically categorical or factor variables)
str(efc$e17age)
str(to_label(efc$e17age))
}
\seealso{
\code{\link{to_fac}} to convert a numeric variable into a factor (and
           retain labels) and \code{\link{to_value}} to convert a factor into
           a numeric variable.
}

