% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_spss}
\alias{read_spss}
\alias{read_sas}
\alias{read_stata}
\title{Import data from other statistical software packages}
\usage{
read_spss(path, atomic.to.fac = FALSE, tag.na = FALSE, enc = NULL,
  verbose = TRUE)

read_sas(path, path.cat = NULL, atomic.to.fac = FALSE, enc = NULL,
  verbose = TRUE)

read_stata(path, atomic.to.fac = FALSE, enc = NULL, verbose = TRUE)
}
\arguments{
\item{path}{File path to the data file.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, categorical variables imported
from the dataset (which are imported as \code{atomic}) will be
converted to factors.}

\item{tag.na}{Logical, if \code{TRUE}, missing values are imported
as \code{\link[haven]{tagged_na}} values; else, missing values are
converted to regular \code{NA} (default behaviour).}

\item{enc}{The character encoding used for the file. This defaults to the encoding
specified in the file, or UTF-8. Use this argument to override the default
encoding stored in the file.}

\item{verbose}{Logical, if \code{TRUE}, a progress bar is displayed that indicates
the progress of converting the imported data.}

\item{path.cat}{Optional, the file path to the SAS catalog file.}
}
\value{
A data frame containing the imported, labelled data. Retrieve value labels with
  \code{\link{get_labels}} and variable labels with \code{\link{get_label}}.
}
\description{
Import data from SPSS, SAS or Stata, including NA's, value and variable
  labels.
}
\details{
These read-functions behave slightly differently from \pkg{haven}'s
  read-functions:
  \itemize{
    \item The vectors in the returned data frame are of class \code{atomic}, not of class \code{labelled}. The labelled-class might cause issues with other packages.
    \item When importing SPSS data, variables with user defined missings \emph{won't} be read into \code{labelled_spss} objects, but imported as \emph{tagged NA values}.
  }
  The \code{atomic.to.fac} option only
  converts those variables into factors that are of class \code{atomic} and
  which have value labels after import. Atomic vectors without value labels
  are considered as continuous and not converted to factors.
}
\note{
These are wrapper functions for \CRANpkg{haven}'s \code{read_*}-functions.
}
\examples{
\dontrun{
# import SPSS data set. uses haven's read function
mydat <- read_spss("my_spss_data.sav")

# use haven's read function, convert atomic to factor
mydat <- read_spss("my_spss_data.sav", atomic.to.fac = TRUE)

# retrieve variable labels
mydat.var <- get_label(mydat)

# retrieve value labels
mydat.val <- get_labels(mydat)}

}
\seealso{
Vignette \href{../doc/intro_sjlabelled.html}{Labelled Data and the sjlabelled-Package}.
}
