% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjSDM_configs.R
\name{sjSDMControl}
\alias{sjSDMControl}
\title{sjSDM control object}
\usage{
sjSDMControl(
  optimizer = RMSprop(),
  scheduler = 0,
  lr_reduce_factor = 0.99,
  early_stopping_training = 0,
  mixed = FALSE
)
}
\arguments{
\item{optimizer}{object of type \code{\link{RMSprop}}, \code{\link{Adamax}}, \code{\link{SGD}}, \code{\link{AccSGD}}, \code{\link{madgrad}}, or \code{\link{AdaBound}}}

\item{scheduler}{reduce lr on plateau scheduler or not (0 means no scheduler, > 0 number of epochs before reducing learning rate)}

\item{lr_reduce_factor}{factor to reduce learning rate in scheduler}

\item{early_stopping_training}{number of epochs without decrease in training loss before invoking early stopping (0 means no early stopping).}

\item{mixed}{mixed (half-precision) training or not. Only recommended for GPUs > 2000 series}
}
\value{
List with the following fields:

\item{optimizer}{Function which returns an optimizer.}
\item{scheduler_boolean}{Logical, use scheduler or not.}
\item{scheduler_patience}{Integer, number of epochs to wait before applying plateau scheduler.}
\item{lr_reduce_factor}{Numerical, learning rate reduce factor.}
\item{mixed}{Logical, use mixed training or not.}
\item{early_stopping_training}{Numerical, early stopping after n epochs.}
}
\description{
sjSDM control object
}
