params <-
list(EVAL = TRUE)

## ----message=FALSE, warning=FALSE, include=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE, 
  comment = "#>", 
  message = FALSE
)

if (!requireNamespace("dplyr", quietly = TRUE) ||
    !requireNamespace("sandwich", quietly = TRUE) ||
    !requireNamespace("lme4", quietly = TRUE)) {
  knitr::opts_chunk$set(eval = FALSE)
} else {
  knitr::opts_chunk$set(eval = TRUE)
  library(sjPlot)
  library(dplyr)
}

set.seed(333)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(iris)
model <- lm(Petal.Length ~ Sepal.Length * Species + Sepal.Width, data = iris)

# model parameters, where SE, CI and p-values are based on robust estimation
tab_model(model, vcov.fun = "HC", show.se = TRUE)

# compare standard errors to result from sandwich-package
unname(sqrt(diag(sandwich::vcovHC(model))))

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# change estimation-type
tab_model(model, vcov.fun = "CL", vcov.type = "HC1", show.se = TRUE)

# compare standard errors to result from sandwich-package
unname(sqrt(diag(sandwich::vcovCL(model))))

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
iris$cluster <- factor(rep(LETTERS[1:8], length.out = nrow(iris)))
# change estimation-type, defining additional arguments
tab_model(
  model, 
  vcov.fun = "CL", 
  vcov.type = "HC1",
  vcov.args = list(cluster = iris$cluster),
  show.se = TRUE
)

# compare standard errors to result from sandwich-package
unname(sqrt(diag(sandwich::vcovCL(model, cluster = iris$cluster))))

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # create fake-cluster-variable, to demonstrate cluster robust standard errors
#  iris$cluster <- factor(rep(LETTERS[1:8], length.out = nrow(iris)))
#  
#  # cluster-robust estimation
#  tab_model(
#    model,
#    vcov.fun = "CR",
#    vcov.type = "CR1",
#    vcov.args = list(cluster = iris$cluster),
#    show.se = TRUE
#  )
#  
#  # compare standard errors to result from clubSsandwich-package
#  unname(sqrt(diag(clubSandwich::vcovCR(model, type = "CR1", cluster = iris$cluster))))

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# model parameters, robust estimation on standardized model
tab_model(
  model, 
  show.std = "std",
  vcov.fun = "HC"
)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(lme4)
#  data(iris)
#  set.seed(1234)
#  iris$grp <- as.factor(sample(1:3, nrow(iris), replace = TRUE))
#  
#  # fit example model
#  model <- lme4::lmer(
#    Sepal.Length ~ Species * Sepal.Width + Petal.Length + (1 | grp),
#    data = iris
#  )
#  
#  # normal model parameters, like from 'summary()'
#  tab_model(model)
#  
#  # model parameters, cluster robust estimation for mixed models
#  tab_model(
#    model,
#    vcov.fun = "CR",
#    vcov.type = "CR1",
#    vcov.args = list(cluster = iris$grp)
#  )

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # model parameters, cluster robust estimation on standardized mixed model
#  tab_model(
#    model,
#    show.std = "std",
#    vcov.fun = "CR",
#    vcov.type = "CR1",
#    vcov.args = list(cluster = iris$grp)
#  )

