% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotStackFrequencies.R
\name{sjp.stackfrq}
\alias{sjp.stackfrq}
\title{Plot stacked proportional bars}
\usage{
sjp.stackfrq(items, title = NULL, legend.title = NULL,
  legend.labels = NULL, axis.titles = NULL, axis.labels = NULL,
  weight.by = NULL, sort.frq = NULL, wrap.title = 50, wrap.labels = 30,
  wrap.legend.title = 30, wrap.legend.labels = 28, geom.size = 0.5,
  geom.colors = "Blues", show.values = TRUE, show.n = TRUE,
  show.prc = TRUE, show.legend = TRUE, grid.breaks = 0.2,
  expand.grid = FALSE, digits = 1, vjust = "center", coord.flip = TRUE,
  prnt.plot = TRUE)
}
\arguments{
\item{items}{Data frame, with each column representing one item.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{legend.title}{character vector, used as title for the plot legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{weight.by}{Vector of weights that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{sort.frq}{Indicates whether the \code{items} should be ordered by
by highest count of first or last category of \code{items}.
\describe{
  \item{\code{"first.asc"}}{to order ascending by lowest count of first category,}
  \item{\code{"first.desc"}}{to order descending by lowest count of first category,}
  \item{\code{"last.asc"}}{to order ascending by lowest count of last category,}
  \item{\code{"last.desc"}}{to order descending by lowest count of last category,}
  \item{\code{NULL}}{(default) for no sorting.}
}}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}

\item{show.prc}{Logical, if \code{TRUE} (default), the percentage values at the x-axis are shown.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{digits}{Numeric, amount of digits after decimal point when rounding estimates and values.}

\item{vjust}{character vector, indicating the vertical position of value
labels. Allowed are same values as for \code{vjust} aesthetics from
\code{ggplot2}: "left", "center", "right", "bottom", "middle", "top" and
new options like "inward" and "outward", which align text towards and
away from the center of the plot respectively.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot items (variables) of a scale as stacked proportional bars. This
               function is useful when several items with identical scale/categoroies
               should be plotted to compare the distribution of answers.
}
\note{
Thanks to \href{http://www.clas.ufl.edu/users/forrest/}{Forrest Stevens} for bug fixes.
}
\examples{
# Data from the EUROFAMCARE sample dataset
library(sjmisc)
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive first item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")
# auto-detection of labels
sjp.stackfrq(efc[, start:end])


}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjp.stackfrq/}{sjPlot manual: sjp.stackfrq}
             \item \code{\link{sjt.stackfrq}}
             }
}
