% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotClusterAnalysis.R
\name{sjc.qclus}
\alias{sjc.qclus}
\title{Compute quick cluster analysis}
\usage{
sjc.qclus(data, groupcount = NULL, groups = NULL, method = "k",
  distance = "euclidean", agglomeration = "ward", iter.max = 20,
  algorithm = "Hartigan-Wong", showAccuracy = FALSE, title = NULL,
  axisLabels.x = NULL, axisTitle.x = "Cluster group characteristics",
  axisTitle.y = "Mean of z-scores", breakTitleAt = 40, breakLabelsAt = 20,
  breakLegendTitleAt = 20, breakLegendLabelsAt = 20, facetCluster = FALSE,
  geom.colors = "Paired", geom.size = 0.5, geom.spacing = 0.1,
  hideLegend = FALSE, showAxisLabels.x = TRUE, showAxisLabels.y = TRUE,
  showGroupCount = TRUE, showAccuracyLabels = FALSE, legendTitle = NULL,
  legendLabels = NULL, coord.flip = FALSE, reverseAxis.x = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{data}{data frame containing all variables that should be used for the
cluster analysis.}

\item{groupcount}{amount of groups (clusters) that should be retrieved. May also be
a set of initial (distinct) cluster centres, in case \code{method = "kmeans"}
(see \code{\link{kmeans}} for details on \code{centers} argument). 
If \code{groupcount = NULL}, the optimal amount of clusters is calculated using the 
gap statistics (see \code{\link{sjc.kgap}}. However, this works only 
with \code{method = "kmeans"}. If \code{method = "hclust"}, you have 
to specify \code{groupcount}. Following functions 
may be helpful for estimating the amount of clusters:
\itemize{
  \item Use \code{\link{sjc.elbow}} to determine the group-count depending on the elbow-criterion.
  \item If \code{method = "kmeans"}, use \code{\link{sjc.kgap}} to determine the group-count according to the gap-statistic.
  \item If \code{method = "hclust"} (hierarchical clustering, default), use \code{\link{sjc.dend}} to inspect different cluster group solutions.
  \item Use \code{\link{sjc.grpdisc}} to inspect the goodness of grouping (accuracy of classification).
  }}

\item{groups}{optional, by default, this argument is \code{NULL} and will be 
ignored. However, to plot existing cluster groups, specify \code{groupcount}
and \code{groups}. \code{groups} is a vector of same length as 
\code{nrow(data)} and indicates the group classification of the cluster 
analysis. The group classification can be computed with the
\code{\link{sjc.cluster}} function. See 'Examples'.}

\item{method}{method for computing the cluster analysis. By default (\code{"kmeans"}), a
kmeans cluster analysis will be computed. Use \code{"hclust"} to 
compute a hierarchical cluster analysis. You can specify the 
initial letters only.}

\item{distance}{distance measure to be used when \code{method = "hclust"} (for hierarchical
clustering). Must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, 
\code{"canberra"}, \code{"binary"} or \code{"minkowski"}. See \code{\link{dist}}.
If is \code{method = "kmeans"} this argument will be ignored.}

\item{agglomeration}{agglomeration method to be used when \code{method = "hclust"} (for hierarchical
clustering). This should be one of \code{"ward"}, \code{"single"}, \code{"complete"}, \code{"average"}, 
\code{"mcquitty"}, \code{"median"} or \code{"centroid"}. Default is \code{"ward"} (see \code{\link{hclust}}).
If \code{method = "kmeans"} this argument will be ignored. See 'Note'.}

\item{iter.max}{maximum number of iterations allowed. Only applies, if 
\code{method = "kmeans"}. See \code{\link{kmeans}} for details on this argument.}

\item{algorithm}{algorithm used for calculating kmeans cluster. Only applies, if 
\code{method = "kmeans"}. May be one of \code{"Hartigan-Wong"} (default), 
\code{"Lloyd"} (used by SPSS), or \code{"MacQueen"}. See \code{\link{kmeans}} 
for details on this argument.}

\item{showAccuracy}{logical, if \code{TRUE}, the \code{\link{sjc.grpdisc}} function will be called,
which computes a linear discriminant analysis on the classified cluster groups and plots a 
bar graph indicating the goodness of classification for each group.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{axisLabels.x}{a character vector with labels for the x-axis breaks. \strong{Note:} 
Axis labels will be automatically detected, when data was either imported 
with \code{\link[sjmisc]{read_spss}} or has named factor levels 
(see 'Examples'). Else, specifiy argument like this:
\code{axisLabels.x = c("Label1", "Label2", "Label3")}.}

\item{axisTitle.x}{title for the x-axis.}

\item{axisTitle.y}{title for the y-axis.}

\item{breakTitleAt}{Determines how many chars of the title are displayed in 
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in 
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{determines how many chars of the legend labels are 
displayed in one line and when a line break is inserted.}

\item{facetCluster}{If \code{TRUE}, each cluster group will be represented by an own panel.
Default is \code{FALSE}, thus all cluster groups are plotted in a single graph.}

\item{geom.colors}{user defined color for bars. See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{geom.size}{width of bars. Recommended values for this argument are from 0.4 to 1.5}

\item{geom.spacing}{the spacing between geoms (i.e. bar spacing)}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{showAxisLabels.x}{whether x axis labels (cluster variables) should be shown or not.}

\item{showAxisLabels.y}{whether y axis labels (z scores) should be shown or not.}

\item{showGroupCount}{if \code{TRUE} (default), the count within each cluster group is added to the 
legend labels (e.g. \code{"Group 1 (n=87)"}).}

\item{showAccuracyLabels}{if \code{TRUE}, the accuracy-values for each cluster group is added to the 
legend labels (e.g. \code{"Group 1 (n=87, accuracy=95.3)"}). Accuracy is calculated by \code{\link{sjc.grpdisc}}.}

\item{legendTitle}{title of the plot legend, as string.}

\item{legendLabels}{labels for the guide/legend. If \code{legendLabels = NULL}
(default), the standard string \code{"Group <nr>"} will be used.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{reverseAxis.x}{if \code{TRUE}, the values on the x-axis are reversed.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Invisibly) returns an object with
          \itemize{
           \item \code{data}: the used data frame for plotting, 
           \item \code{plot}: the ggplot object,
           \item \code{groupcount}: the number of found cluster (as calculated by \code{\link{sjc.kgap}})
           \item \code{classification}: the group classification (as calculated by \code{\link{sjc.cluster}}), including missing values, so this vector can be appended to the original data frame.
           \item \code{accuracy}: the accuracy of group classification (as calculated by \code{\link{sjc.grpdisc}}).
          }
}
\description{
Compute a quick kmeans or hierarchical cluster analysis and displays "cluster characteristics"
               as graph.
               \enumerate{
               \item If \code{method = "kmeans"}, this function first determines the optimal group count via gap statistics (unless argument \code{groupcount} is specified), using the \code{\link{sjc.kgap}} function.
               \item A cluster analysis is performed by running the \code{\link{sjc.cluster}} function to determine the cluster groups.
               \item Then, all variables in \code{data} are scaled and centered. The mean value of these z-scores within each cluster group is calculated to see how certain characteristics (variables) in a cluster group differ in relation to other cluster groups.
               \item These results are plotted as graph.
               }
               This method can also be used to plot existing cluster solution as graph witouth computing
               a new cluster analysis. See argument \code{groups} for more details.
}
\note{
See 'Note' in \code{\link{sjc.cluster}}
}
\examples{
\dontrun{
# k-means clustering of mtcars-dataset
sjc.qclus(mtcars)

# k-means clustering of mtcars-dataset with 4 pre-defined
# groups in a faceted panel
sjc.qclus(airquality, 
          groupcount = 4, 
          facetCluster = TRUE)}
          
# k-means clustering of airquality data
# and saving the results. most likely, 3 cluster
# groups have been found (see below).
airgrp <- sjc.qclus(airquality)

# "re-plot" cluster groups, without computing
# new k-means cluster analysis.
sjc.qclus(airquality,
          groupcount = 3,
          groups = airgrp$classification)

}
\references{
Maechler M, Rousseeuw P, Struyf A, Hubert M, Hornik K (2014) cluster: Cluster Analysis Basics and Extensions. R package.
}

