% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotAnova.R
\name{sjp.aov1}
\alias{sjp.aov1}
\title{Plot One-Way-Anova tables}
\usage{
sjp.aov1(depVar, grpVar, meansums = FALSE, title = NULL,
  axisLabels.y = NULL, reverseOrder = FALSE,
  stringIntercept = "(Intercept)", showAxisLabels.y = TRUE,
  axisTitle.x = "", axisLimits = NULL, geom.colors = c("#3366a0",
  "#aa3333"), geom.size = 3, breakTitleAt = 50, breakLabelsAt = 25,
  gridBreaksAt = NULL, expand.grid = FALSE, showValueLabels = TRUE,
  labelDigits = 2, y.offset = 0.1, showPValueLabels = TRUE,
  showModelSummary = FALSE, printPlot = TRUE)
}
\arguments{
\item{depVar}{dependent variable. Will be used with following formula:
\code{aov(depVar ~ grpVar)}}

\item{grpVar}{grouping variable, as unordered factor. Will be used with following formula:
\code{aov(depVar ~ grpVar)}}

\item{meansums}{logical, if \code{TRUE}, the values reported are the true group mean values (see also \code{\link{sjt.grpmean}}).
If \code{FALSE} (default), the values are reported in the standard way, i.e. the values indicate the difference of
the group mean in relation to the intercept (reference group).}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{axisLabels.y}{character vector, indicating the value labels of \code{grpVar} that 
are used for labelling the axis. See 'Examples'.}

\item{reverseOrder}{logical, if \code{TRUE}, the order of categories (groups) is reversed.
Default is \code{FALSE}.}

\item{stringIntercept}{string that indicates the reference group (intercept), that is appended to
the value label of the grouping variable. Default is \code{"(Intercept)"}.}

\item{showAxisLabels.y}{logical, whether y-axis labels (count values) should be shown or not.}

\item{axisTitle.x}{title for the x-axis. By default, \code{""} is used, i.e. no title
is printed. If \code{axisTitle.x = NULL}, the variable name will be 
automatically detected and used as title (see \code{\link[sjmisc]{set_label}}) 
for details).}

\item{axisLimits}{numeric vector of length 2, defining the range of the plot axis.
By default, the limits range from the lowest confidence interval to the 
highest, so plot has maximum zoom.}

\item{geom.colors}{vector of length two, indicating the colors of the points; 
first value is for groups with positive means and the second for 
negative means.}

\item{geom.size}{size of the points. Default is 3.}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in 
one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th 
position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{showValueLabels}{logical, whether the value labels (mean differences) should be plotted 
to each dot or not.}

\item{labelDigits}{amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{y.offset}{numeric, offset for text labels when their alignment is adjusted 
to the top/bottom of the geom (see \code{hjust} and \code{vjust}).}

\item{showPValueLabels}{logical, whether the significance level of each coefficient
should be appended to values or not.}

\item{showModelSummary}{logical, if \code{TRUE}, a summary of the anova model with 
Sum of Squares between groups (ssb), Sum of Squares within groups (ssw), multiple and adjusted 
R-square and F-Test is printed to the lower right corner
of the diagram. Default is \code{TRUE}.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot One-Way-Anova table sum of squares (SS) of each factor level (group) 
               against the dependent variable. The SS of the factor variable against the 
               dependent variable (variance within and between groups) is printed to
               the model summary.
}
\examples{
library(sjmisc)
data(efc)
# note: "grpVar" does not need to be a factor.
# coercion to factor is done by the function
sjp.aov1(efc$c12hour, efc$e42dep)


}
\seealso{
\code{\link{sjt.grpmean}}
}

