% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjPlotLinreg.R
\name{sjp.lm}
\alias{sjp.lm}
\title{Plot beta coefficients of lm}
\usage{
sjp.lm(fit, sort = "beta", title = NULL, axisLabels.y = NULL,
  showAxisLabels.y = TRUE, axisTitle.x = "Estimates", axisLimits = NULL,
  geom.colors = "Set1", geom.size = 3, stdBetaLineType = 2,
  stdBetaLineAlpha = 0.3, interceptLineType = 2,
  interceptLineColor = "grey70", breakTitleAt = 50, breakLabelsAt = 25,
  gridBreaksAt = NULL, coord.flip = TRUE, showValueLabels = TRUE,
  labelDigits = 2, showPValueLabels = TRUE, showModelSummary = TRUE,
  showStandardBeta = FALSE, showStandardBetaLine = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{fit}{The model of the linear regression (lm-Object).}

\item{sort}{Determines whether the predictors are sorted by beta-values (default, or use \code{"beta"} as
parameter) or by standardized beta values (use \code{"std"}).}

\item{title}{Diagram's title as string.
Example: \code{title=c("my title")}}

\item{axisLabels.y}{Labels of the predictor variables (independent vars) that are used for labelling the
axis. Passed as vector of strings.
Example: \code{axisLabels.y=c("Label1", "Label2", "Label3")}.
Note: If you use the \code{\link{sji.SPSS}} function and the \code{\link{sji.getValueLabels}} function, you receive a
list object with label string. The labels may also be passed as list object. They will be unlisted and
converted to character vector automatically.}

\item{showAxisLabels.y}{Whether x axis text (category names, predictor labels) should be shown (use \code{TRUE})
or not. Default is \code{TRUE}}

\item{axisTitle.x}{A label for the x axis. Default is \code{"Estimates"}.}

\item{axisLimits}{Defines the range of the axis where the beta coefficients and their confidence intervalls
are drawn. By default, the limits range from the lowest confidence interval to the highest one, so
the diagram has maximum zoom. Use your own values as 2-value-vector, for instance: \code{limits=c(-0.8,0.8)}.}

\item{geom.colors}{User defined color palette for geoms. Must either be vector with two color values
or a specific color palette code (see below).
\itemize{
  \item If not specified, the diverging \code{"Paired"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
}
Else specify your own color values as vector (e.g. \code{geom.colors=c("#f00000", "#00ff00")}).}

\item{geom.size}{size resp. width of the geoms (bar width or point size, depending on \code{type} parameter).}

\item{stdBetaLineType}{The standardized beta-value dots are connected by a thin line
for a better overview. With this parameter you can specify the line type.}

\item{stdBetaLineAlpha}{The alpha-value for the line that connects the
standardized beta-value dots.}

\item{interceptLineType}{The linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{The color of the intercept line. Default value is \code{"grey70"}.}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is \code{NULL}, so \code{\link{pretty}} gridbeaks will be used.}

\item{coord.flip}{If \code{TRUE} (default), predictors are plotted on the left y-axis and estimate
values are plotted on the x-axis.}

\item{showValueLabels}{Whether the beta and standardized beta values should be plotted
to each dot or not.}

\item{labelDigits}{The amount of digits for rounding the estimations (see \code{showValueLabels}).
Default is 2, i.e. estimators have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not}

\item{showModelSummary}{If \code{TRUE} (default), a summary of the regression model with
Intercept, R-square, F-Test and AIC-value is printed to the lower right corner
of the diagram.}

\item{showStandardBeta}{Whether or not the dots for the standardized beta values
should be plotted to the diagram.}

\item{showStandardBetaLine}{Whether or not the connecting line for the standardized beta values
should be plotted to the diagram. Default is \code{FALSE}.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot beta coefficients (estimates) of linear regressions with confidence intervalls as dot plot
               (forest plot). Additionally, the standardized beta values are plotted
               as red dots.
}
\examples{
# fit linear model
fit <- lm(airquality$Ozone ~ airquality$Wind + airquality$Temp + airquality$Solar.R)

# plot estimates with CI and standardized beta-values
sjp.lm(fit, gridBreaksAt=2)

# plot estimates with CI without standardized beta-values
# and with narrower tick marks (because "gridBreaksAt" was not specified)
sjp.lm(fit, showStandardBeta=FALSE)
}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjp.lm}{sjPlot manual: sjp.lm}
             \item \code{\link{sjp.lm.ma}}
             \item \code{\link{sjp.reglin}}
             \item \code{\link{sjp.int}}
             \item \code{\link{sjp.scatter}}
             \item  \code{\link{sjs.stdb}}
            }
}

