% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_fecha_inisintomas}
\alias{agrupar_fecha_inisintomas}
\title{Agrupar por fecha de inicio de síntomas y casos}
\usage{
agrupar_fecha_inisintomas(data_event, col_fecha = "ini_sin")
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de
la enfermedad o evento.}

\item{col_fecha}{Un `character` (cadena de caracteres) con el
nombre de la columna de los datos de la enfermedad o evento que contiene
las fechas de inicio de síntomas; su valor por defecto es `"ini_sin"`.}
}
\value{
Un `data.frame` con los datos de la enfermedad o evento
agrupados por fecha de inicio de síntomas y número de casos.
}
\description{
Función que agrupa los datos de una enfermedad o evento por
fecha de inicio de síntomas y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_fecha_inisintomas(
  data_event = data_limpia,
  col_fecha = "ini_sin"
)
}
