% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_predictors.R
\name{sits_stats}
\alias{sits_stats}
\title{Obtain statistics for all sample bands}
\usage{
sits_stats(samples)
}
\arguments{
\item{samples}{Time series samples uses as training data.}
}
\value{
A list with the 2% and 98% quantiles for each band of the
training data.
}
\description{
Most machine learning algorithms require data to be
normalized. This applies to the "SVM" method and to all deep learning ones.
To normalize the predictors, it is necessary to extract the statistics
of each band of the samples. This function computes the 2% and 98% quantiles
of the distribution of each band of the samples. This values are used as
minimum and maximum values in the normalization operation performed by
the sits_pred_normalize() function.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
     stats <- sits_stats(samples_modis_ndvi)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
