% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_config.R
\name{sits_configuration}
\alias{sits_configuration}
\alias{sits_config}
\alias{sits_config_show}
\alias{sits_list_collections}
\title{Configure parameters for sits package}
\usage{
sits_config(
  processing_bloat = NULL,
  rstac_pagination_limit = NULL,
  raster_api_package = NULL,
  gdal_creation_options = NULL,
  gdalcubes_chunk_size = NULL,
  leaflet_max_megabytes = NULL,
  leaflet_comp_factor = NULL,
  reset = FALSE
)

sits_config_show(source = NULL, collection = NULL, colors = FALSE)

sits_list_collections(source = NULL)
}
\arguments{
\item{processing_bloat}{Estimated growth size of R memory relative
to block size.}

\item{rstac_pagination_limit}{Limit of number of items returned by STAC.}

\item{raster_api_package}{Supported raster handling package.}

\item{gdal_creation_options}{GDAL creation options for GeoTiff.}

\item{gdalcubes_chunk_size}{Chunk size to be used by gdalcubes}

\item{leaflet_max_megabytes}{Max image size of an image for leaflet (in MB)}

\item{leaflet_comp_factor}{Compression factor for leaflet RGB display.}

\item{reset}{Should current configuration options be cleaned
before loading config files? Default is
\code{FALSE}.}

\item{source}{Data source to be shown in detail.}

\item{collection}{Collection key entry to be shown in detail.}

\item{colors}{Show colors?}
}
\value{
\code{sits_config()} returns a \code{list} containing the final
configuration options.

A \code{list} containing the respective
configuration printed in the console.

Prints collections available in each cloud service supported by sits.
}
\description{
These functions load and show sits configurations.

The `sits` package uses a configuration file
that contains information on parameters required by different functions.
This includes information about the image collections handled by `sits`.

\code{sits_config()} loads the default configuration file and
the user provided configuration file. The final configuration is
obtained by overriding the options by the values provided in
\code{processing_bloat}, \code{rstac_pagination_limit},
\code{raster_api_package}, and \code{gdal_creation_options} parameters.

\code{sits_config_show()} prints the current sits
configuration options. To show specific configuration options for
a source, a collection, or a palette, users can inform the corresponding
keys to \code{source}, \code{collection}, and \code{palette} parameters.

\code{sits_list_collections()} prints the collections available
in each cloud service supported by sits. Users can select to get information
only for a single service by using the \code{source} parameter.
}
\details{
Users can provide additional configuration files, by specifying the
location of their file in the environmental variable
\code{SITS_CONFIG_USER_FILE}.

To see the key entries and contents of the current configuration values,
use \code{sits_config_show()}.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
