% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.predict}
\alias{sirus.predict}
\title{Predict.}
\usage{
sirus.predict(sirus.m, data.test)
}
\arguments{
\item{sirus.m}{A SIRUS model generated by \code{\link{sirus.fit}}.}

\item{data.test}{Testing data (dataframe of new observations).}
}
\value{
Predictions. For classification, vector of the predicted probability of each new observation to be of class 1.
}
\description{
Compute SIRUS predictions for new observations.
}
\examples{
## load SIRUS
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

#' ## fit SIRUS
sirus.m <- sirus.fit(data, y)

## predict
predictions <- sirus.predict(sirus.m, data)

}
