% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{vcov.singleR}
\alias{vcov.singleR}
\title{Obtain Covariance Matrix estimation.}
\usage{
\method{vcov}{singleR}(object, type = c("Fisher", "observedInform"), ...)
}
\arguments{
\item{object}{object of singleR class.}

\item{type}{type of estimate for covariance matrix for now either
expected (Fisher) information matrix or observed information matrix.}

\item{...}{additional arguments for method functions}
}
\value{
A covariance matrix for fitted coefficients, rows and columns of which
correspond to parameters returned by \code{coef} method.
}
\description{
A \code{vcov} method for \code{singleR} class.
}
\details{
Returns a estimated covariance matrix for model coefficients
calculated from analytic hessian or Fisher information matrix usually
utilising asymptotic effectiveness of maximum likelihood estimates.
Covariance type is taken from control parameter that have been provided
on call that created \code{object} if arguments \code{type} was not specified.
}
\seealso{
\code{\link[=vcovHC.singleR]{vcovHC.singleR()}} \code{\link[sandwich:sandwich]{sandwich::sandwich()}}
}
