% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deficit_power.R
\name{BTD_power}
\alias{BTD_power}
\title{Power calculator for BTD}
\usage{
BTD_power(
  case,
  mean = 0,
  sd = 1,
  sample_size,
  alternative = c("less", "greater", "two.sided"),
  alpha = 0.05,
  nsim = 1000,
  iter = 1000
)
}
\arguments{
\item{case}{A single value from the expected case observation.}

\item{mean}{The expected mean of the control sample.}

\item{sd}{The expected standard deviation of the control sample.}

\item{sample_size}{The size of the control sample, vary this parameter to see
how the sample size affects power.}

\item{alternative}{The alternative hypothesis. A string of either "less" (default),
"greater" or "two.sided".}

\item{alpha}{The specified Type I error rate. This can also be varied, with
effects on power.}

\item{nsim}{The number of simulations for the power calculation. Defaults to
1000 due to BTD already being computationally intense.}

\item{iter}{The number of simulations used by the BTD. Defaults to 1000.}
}
\value{
Returns a single value approximating the power of the test for the
  given parameters.
}
\description{
Calculates approximate power, given sample size, using Monte Carlo simulation for the
Bayesian test of deficit for a specified case score, mean and standard
deviation for the control sample. The mean and standard deviation defaults to
0 and 1, so if no other values are given the case score is interpreted as
deviation from the mean in standard deviations.
}
\examples{
BTD_power(case = -2, mean = 0, sd = 1, sample_size = 20)
}
