% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPlot2.R
\name{contourPlot2}
\alias{contourPlot2}
\title{New contour plot of pollutant concentration field}
\usage{
contourPlot2(
  data,
  x = "x",
  y = "y",
  z = "z",
  domain = NULL,
  background = NULL,
  underlayer = NULL,
  overlayer = NULL,
  legend = NULL,
  levels = NULL,
  size = 0,
  fill = TRUE,
  tile = FALSE,
  transparency = 0.75,
  colors = NULL,
  bare = FALSE
)
}
\arguments{
\item{data}{dataframe in long format, with three columns for Easting,
Northing and values to be plotted.}

\item{x}{name of the column with Easting data (default "x").}

\item{y}{name of the column with Northing data (default "y").}

\item{z}{name of the column with the values to be plotted (default
"z").}

\item{domain}{optional list with six numeric values defining the
boundaries of the domain to be plotted: minimum X, maximum X, minimum Y,
maximum Y, number of ticks on X axis, number of ticks on Y axis.}

\item{background}{optional path to a png file to be plotted as the base map.}

\item{underlayer}{optional list of layers to be plotted between base map
and contour plot.}

\item{overlayer}{optional list of layers to be plotted on top of the contour
plot.}

\item{legend}{optional title of the legend.}

\item{levels}{numeric vector of levels for contour plot. If not set,
automatic pretty levels are computed. If \code{-Inf} and \code{Inf} are used as the lowest
and highest limits of the array, the lowest and highest bands are unbounded
and the legend shows \code{<} and \code{>=} symbols.}

\item{size}{thickness of the contour line.}

\item{fill}{boolean (default TRUE). If TRUE the contour plot is filled with
colour.}

\item{tile}{boolean (default FALSE). If TRUE rectangular tiles are plotted.}

\item{transparency}{transparency level of the contour plot between 0.0
(fully transparent) and 1.0 (fully opaque). Default = 0.75).}

\item{colors}{colour palette for contour plot, as an array of colours.}

\item{bare}{boolean (default FALSE). If TRUE only the bare plot is shown:
axis, legend, titles and any other graphical element of the plot are removed.}
}
\value{
A \code{ggplot2} object.
}
\description{
\code{contourPlot2} plots a contour map of a given quantity, such as the
ground concentration of an airborne pollutant or odour, defined on a
regular grid.
}
\details{
This is a convenience function to plot contour levels of a scalar quantity
such as pollutants computed by a dispersion model, with \code{ggplot2}
version >= 3.3.0.

Data are required to be on a regular grid, typically (but not necessarily)
in UTM coordinates. The input dataframe has to be in long format, i.e. one
line per value to be plotted. The names of the columns corresponding to \code{x},
\code{y} and \code{z} can be specified in the input parameters.

If \code{tile = TRUE} data are shown as they are, without any graphical
interpolation required for contour plots. This is helpful when you want to
visualise the raw data.
Since version 2.4.0, when \code{tile = TRUE} the intervals include the lowest
bound and exclude the highest bound: \verb{[min, max)}. Note: In previous version
it was the opposite.

\code{underlayer} and \code{overlayer} layers are \code{ggplot2} objects to be shown at
different levels of the vertical stack of the plot. These are useful to
show topographical information related to the plot, such as sources
or receptors locations.
}
\examples{
# Load example data in long format
data(volcano)
volcano3d <- reshape2::melt(volcano)
names(volcano3d) <- c("x", "y", "z")
# Contour plot with default options
v <- contourPlot2(volcano3d)
v

# Set levels, and properly format the legend title:
contourPlot2(volcano3d, 
             levels = c(-Inf, seq(100, 200, 20), Inf),
             legend = expression(PM[10]~"["~mu*g~m^-3~"]"))

# Sometimes, instead of a contour plot it is better to plot the original
# raster data, without any interpolation:
contourPlot2(volcano3d, 
             levels = c(-Inf, seq(100, 200, 20), Inf), 
             tile = TRUE)

# Since contourPlot2 returns a `ggplot2` object, you can add instructions as:
library(ggplot2)
v + ggtitle("Example volcano data") +
    labs(x = NULL, y = NULL)

}
