% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_generic_sarima}
\alias{gen_generic_sarima}
\title{Generate Generic Seasonal Autoregressive Order P - Moving Average Order Q (SARMA(p,q)x(P,Q)) Model}
\usage{
gen_generic_sarima(N, theta_values, objdesc, sigma2 = 1.5,
  n_start = 0L)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{theta_values}{A \code{vec} containing the parameters for (S)AR and (S)MA.}

\item{objdesc}{A \code{vec} that contains the \code{\link{+.ts.model}}'s obj.desc field.}

\item{sigma2}{A \code{double} that contains process variance.}

\item{n_start}{An \code{unsigned int} that indicates the amount of observations to be used for the burn in period.}

\item{s}{An \code{integer} that contains a seasonal id.}
}
\value{
A \code{vec} that contains the generated observations.
}
\description{
Generate an ARMA(P,Q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
}
\details{
The innovations are generated from a normal distribution.
The \eqn{\sigma^2} parameter is indeed a variance parameter. 
This differs from R's use of the standard deviation, \eqn{\sigma}.
}
\keyword{internal}
