% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.R
\name{extend}
\alias{extend}
\title{Extend a longitudinal model.}
\usage{
extend(object, along, within, n, values)
}
\arguments{
\item{object}{a fitted model object to extend.}

\item{along}{the name of an explanatory variable. This variable will have its number of levels extended.}

\item{within}{names of grouping variables, separated by "+" or ",". Each combination of groups will be
extended to \code{n} rows.}

\item{n}{number of levels: the levels of the explanatory variable will be replaced by \code{1,2,3,..,n} for a
continuous variable or \code{a,b,c,...,n} for a factor.}

\item{values}{alternatively, you can specify a new set of levels for the explanatory variable.}
}
\value{
A copy of \code{object} suitable for \code{\link{doSim}} with an extended dataset attached as
an attribute named \code{newData}.
}
\description{
This method increases the sample size for a model.
}
\details{
\code{extend} takes "slices" through the data for each unique value of the extended variable.
An extended dataset is built from \code{n} slices, with slices duplicated if necessary.
}
\examples{
fm <- lmer(y ~ x + (1|g), data=simdata)
nrow(example)
fmx1 <- extend(fm, along="x", n=20)
nrow(getData(fmx1))
fmx2 <- extend(fm, along="x", values=c(1,2,4,8,16))
nrow(getData(fmx2))

}

