% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpr_spec.R
\name{print.simpr_spec}
\alias{print.simpr_spec}
\alias{new_simpr_spec}
\alias{is.simpr_spec}
\title{Methods for simpr_spec class}
\usage{
\method{print}{simpr_spec}(x, ...)

new_simpr_spec()

is.simpr_spec(x)
}
\arguments{
\item{x}{a \code{simpr_spec} object}

\item{\dots}{ignored}
}
\value{
\code{print.simpr_spec} has no return value
  and is called for its side-effects.
  \code{new_simpr_spec} returns an empty
  \code{simpr_spec} object. \code{is.simpr_spec} returns
  a length-1 logical vector, \code{TRUE} or \code{FALSE},
  which indicates whether an object is a
  \code{simpr_spec}.
}
\description{
Accessor & display methods for simpr_spec class
}
\details{
Class \code{simpr_spec} is created by
\code{\link[=specify.formula]{specify}} and/or
\code{\link{define}} to specify the simulation
variables, which is produced by
\code{\link[=generate.simpr_spec]{generate}}.
The print method provides an overview of the
specification, including the conditions.
}
\examples{
empty = new_simpr_spec()
print(empty)

## Easiest to create a simpr_spec with specify
simple_spec = specify(a = ~ rbinom(n, size, prob))
print(simple_spec)

## Adding on define adds all possible combinations
## of conditions and more info in output.
defined_spec = specify(a = ~ rbinom(n, size, prob)) \%>\%
  define(n = c(10, 20),
         size = c(20, 40),
         prob = c(0.2, 0.4))
print(defined_spec)

}
