% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinadic.R
\name{nat_to_sub}
\alias{nat_to_sub}
\title{nat_to_sub}
\usage{
nat_to_sub(x, n, k)
}
\arguments{
\item{x}{non-negative integers in the range \code{c(1, choose(n, k))}}

\item{n}{numerator of the binomial coefficient}

\item{k}{denominator of the binomial coefficient}
}
\value{
integer matrix whose columns give the combinadics of \code{x}.
}
\description{
Computes the \code{x}^th (\code{n} choose \code{2}) combination.
}
\details{
The mapping is done via an lexicographically-ordered combinadic mapping. \cr
In general, this function is \emph{not} intended to be used to \emph{generate} all (n choose \code{k})  combinations in the combinadic mapping.
}
\examples{
library(simplextree)
all(nat_to_sub(seq(choose(100,2)), n = 100, k = 2) == combn(100,2))

## Generating pairwise combinadics is particularly fast
## Below: test to generate ~ 45k combinadics (note: better to use microbenchmark) 
system.time({
  x <- seq(choose(300,2))
  nat_to_sub(x, n = 300, k = 2L)
})

## Compare with generating raw combinations
system.time(combn(300,2))
}
\references{
McCaffrey, J. D. "Generating the mth lexicographical element of a mathematical combination." MSDN Library (2004).
}
