% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sf.R
\name{gg_sf_col}
\alias{gg_sf_col}
\title{Simple feature ggplot map that is coloured.}
\usage{
gg_sf_col(data, col_var, text_var = NULL, pal = NULL,
  pal_rev = FALSE, size_point = 1, size_line = 0.5, alpha = 0.9,
  borders = NULL, borders_behind = TRUE, borders_pal = "#7f7f7f",
  borders_size = 0.2, title = NULL, title_wrap = 100,
  subtitle = NULL, subtitle_wrap = 100, col_cuts = NULL,
  col_labels = NULL, col_labels_dp = NULL, col_legend_ncol = NULL,
  col_legend_nrow = NULL, col_na = TRUE, col_method = NULL,
  col_title = NULL, col_title_wrap = 25, caption = NULL,
  caption_wrap = 80, font_family = "", font_size_title = NULL,
  font_size_body = NULL, mobile = FALSE)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{size_point}{Size of points. Defaults to 0.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{alpha}{The opacity of polygons. Defaults to 0.9.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_behind}{TRUE or FALSE  as to whether the borders is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{borders_pal}{Colour of the borders. Defaults to "#7F7F7F".}

\item{borders_size}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string. Defaults to NULL.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_labels}{A function or vector to modify colour scale labels, as per the ggplot2 labels argument in ggplot2 scales functions. If NULL, categorical variable labels are converted to sentence case, and numeric variable labels to pretty labels with an internal function. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_labels_dp}{For numeric colour variables and where col_labels equals NULL, the number of decimal places. Defaults to 1 for "quantile" col_method, and the lowest dp within the col_cuts vector for "bin".}

\item{col_legend_ncol}{The number of columns in the legend.}

\item{col_legend_nrow}{The number of rows in the legend.}

\item{col_na}{TRUE or FALSE of whether to include col_var NA values. Defaults to TRUE.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." NULL results in "category", if categorical or "quantile" if numeric col_var. Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where mobile equals TRUE.}

\item{font_family}{Font family to use. Defaults to "".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within a shiny app with the mobileDetect function, then use mobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is coloured, but not facetted.
}
\examples{
gg_sf_col(example_sf_point, 
          col_var = trend_category, 
          borders = nz)
   
gg_sf_col(example_sf_polygon, 
          col_var = density, 
          borders = nz, 
          col_method = "bin", 
          col_cuts = c(0, 10, 50, 100, 150, 200, Inf))

gg_sf_col(example_sf_polygon, 
          col_var = density, 
          borders = nz, 
          col_method = "quantile", 
          col_cuts = c(0, 0.25, 0.5, 0.75, 0.95, 1))
          
}
