% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sf_fun.R
\name{ggplot_sf_col_facet}
\alias{ggplot_sf_col_facet}
\title{Map of simple features in ggplot that is coloured and facetted.}
\usage{
ggplot_sf_col_facet(data, col_var, facet_var, col_method = NULL,
  col_cuts = NULL, col_quantile_by_facet = TRUE, pal = NULL,
  pal_rev = FALSE, size = 0.5, alpha = 0.9, facet_nrow = NULL,
  legend_ncol = 3, legend_digits = 1, boundary = NULL,
  boundary_behind = TRUE, boundary_pal = "#7f7f7f",
  boundary_size = 0.2, title = "[Title]", subtitle = NULL,
  col_title = "", caption = NULL, legend_labels = NULL,
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, title_wrap = 70, subtitle_wrap = 80,
  wrap_col_title = 25, caption_wrap = 80)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." NULL results in "category", if categorical or "quantile" if numeric col_var. Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_quantile_by_facet}{TRUE of FALSE  whether quantiles should be calculated for each group of the facet variable. Defaults to TRUE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{size}{Size of features (or shape outlines if polygon). Defaults to 0.5.}

\item{alpha}{The opacity of polygons. Defaults to 0.9.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{legend_ncol}{The number of columns in the legend.}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{boundary}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added.}

\item{boundary_behind}{TRUE or FALSE  as to whether the boundary is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{boundary_pal}{Colour of the boundary. Defaults to "#7F7F7F".}

\item{boundary_size}{Size of the boundary. Defaults to 0.2.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is coloured and facetted.
}
\examples{
 pal <- c("#4575B4", "#D3D3D3", "#D73027")

ggplot_sf_col_facet(data = example_sf_point, col_var = trend_category, facet_var = trend_category,
 boundary = nz, pal = pal,
 title = "Trends, 1990-2017")
}
