% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-mnist.R
\name{load_mnist}
\alias{load_mnist}
\title{Load Training Data}
\usage{
load_mnist(train_prop = 0.8, validate_prop = 0.1)
}
\arguments{
\item{train_prop}{proportion of the data used for the training set}

\item{validate_prop}{proportion of the data used for the validation set}
}
\value{
list of training and validation data and targets
}
\description{
Loads MNIST training, validation, and test data and generates one hot
encodings for the targets. The test set proportion is not specified and is
instead the remainder from the test and validation proportions.
}
\examples{
\donttest{
mnist <- load_mnist(0.8, 0.1)
train_data <- mnist[1]
train_target <- mnist[2]
validate_data <- mnist[3]
validate_target <- mnist[4]
test_data <- mnist[5]
test_target <- mnist[6]
}
}
