% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacheDirectories.R
\name{setCacheDir}
\alias{setCacheDir}
\title{Sets a global variable specifying the default cache directory for
simpleCache() calls.}
\usage{
setCacheDir(cacheDir)
}
\arguments{
\item{cacheDir}{Directory where caches should be stored}
}
\description{
Sets a global variable specifying the default cache directory for
simpleCache() calls.
}
\examples{
# choose location to store caches
cacheDir = tempdir()
cacheDir
setCacheDir(cacheDir)

# build some caches
simpleCache("normSample", { rnorm(5e3, 0,1) }, recreate=TRUE, timer=TRUE)
simpleCache("normSample", { rnorm(5e3, 0,1) })
simpleCache("normSample", { rnorm(5e3, 0,1) }, reload=TRUE)

# storing a cache after-the-fact
normSample2 = rnorm(10, 0, 1)
storeCache("normSample2")

# what's available?
listCaches()

# load a cache
simpleCache("normSample")

# load multiples caches
loadCaches(c("normSample", "normSample2"), reload=TRUE)
}
