% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{resultToList}
\alias{resultToList}
\title{Convert result to list}
\usage{
resultToList(result, expand = FALSE, from = NULL, to = NULL)
}
\arguments{
\item{result}{handle to the data container returned by \code{\link{getResult}}}

\item{expand}{if true columns with arrays are partially expanded}

\item{from}{start of the result range, if to/from are not set, full result is returned}

\item{to}{end of the result range, if to/from are not set, full result is returned}
}
\value{
list with output columns
}
\description{
Converts all scalar output columns to appropriate R lists. Columns containing
arrays are left unchanged, unless expand is TRUE.
}
\examples{
\dontrun{
simplace <- initSimplace(SimplaceInstallationDir,SimplaceWorkDir,SimplaceOutputDir)
openProject(simplace, Solution)
parameter <- list(vTempLimit = 32)
simid <- createSimulation(simplace,parameter)
runSimulations(simplace)
closeProject(simplace)
result <- getResult(simplace,"DIAGRAM_OUT", simid);
resultlist <- resultToList(result)
resultlist$CURRENT.DATE}
}
\seealso{
\code{\link{resultToDataframe}} returns the scalar output columns as \code{\link{data.frame}}
}
