% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow_sim_glm.r
\name{sim_pow_glm_nested}
\alias{sim_pow_glm_nested}
\title{Power simulation for nested designs}
\usage{
sim_pow_glm_nested(fixed, random, fixed_param, random_param = list(),
  cov_param, n, p, data_str, cor_vars = NULL, fact_vars = list(NULL),
  unbal = list(level2 = FALSE, level3 = FALSE), unbal_design = list(level2 =
  NULL, level3 = NULL), missing = FALSE, missing_args = list(NULL),
  pow_param = NULL, alpha, pow_dist = c("z", "t"), pow_tail = c(1, 2),
  lme4_fit_mod = NULL, lme4_fit_family, ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation. 
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights). 
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var = variance of random parameters,
   \item  rand_gen = Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    'level1' or 'level2'. 
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{n}{Cluster sample size.}

\item{p}{Within cluster sample size.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels: Number of levels for ordinal or factor variables.
     \item var_type: Must be 'level1' or 'level2'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A named TRUE/FALSE list specifying whether unbalanced simulation 
design is desired. The named elements must be: "level2" or "level3" representing
unbalanced simulation for level two and three respectively. Default is FALSE,
indicating balanced sample sizes at both levels.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the actual sample sizes within each cluster
can be specified. This takes the form of a vector that must have the same length 
as the level two or three sample size. These are specified as a named list in which
level two sample size is controlled via "level2" and level three sample size is 
controlled via "level3".}

\item{missing}{TRUE/FALSE flag indicating whether missing data should be 
simulated.}

\item{missing_args}{Additional missing arguments to pass to the missing_data 
function. See \code{\link{missing_data}} for examples.}

\item{pow_param}{Name of variable to calculate power for, must be a name 
from fixed.}

\item{alpha}{What should the per test alpha rate be used for the hypothesis
testing.}

\item{pow_dist}{Which distribution should be used when testing hypothesis 
test, z or t?}

\item{pow_tail}{One-tailed or two-tailed test?}

\item{lme4_fit_mod}{Valid lme4 formula syntax to be used for model fitting.}

\item{lme4_fit_family}{Valid lme4 family specification passed to glmer.}

\item{...}{Not currently used.}
}
\description{
Takes simulation conditions as input, exports power.
}
\details{
Power function to compute power for a regression term for the generalized 
linear mixed model. This function would need to be replicated to make any 
statement about power.  Use \code{\link{sim_pow_glm}} as a convenient wrapper 
for this.
}
\seealso{
\code{\link{sim_pow_glm}} for a wrapper to replicate.
}
