% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Reproduces.r
\name{mate.backcro}
\alias{mate.backcro}
\title{Back cross}
\usage{
mate.backcro(SP, ncpus = 0, verbose = TRUE)
}
\arguments{
\item{SP}{a list of all simulation parameters.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$reprod$pop.gen}{the generations of simulated population.}
\item{$reprod$reprod.way}{reproduction method, it consists of 'clone', 'dh', 'selfpol', 'randmate', 'randexself', 'assort', 'disassort', '2waycro', '3waycro', '4waycro', 'backcro', and 'userped'.}
\item{$reprod$sex.rate}{the sex ratio of simulated population.}
\item{$reprod$prog}{the progeny number of an individual.}
\item{$geno}{a list of genotype simulation parameters.}
\item{$pheno}{a list of phenotype simulation parameters.}
}
}
\description{
Produce individuals by back cross.
}
\details{
Build date: Apr 12, 2022
Last update: Apr 30, 2022
}
\examples{
\donttest{
# Generate annotation simulation parameters
SP <- param.annot(qtn.num = list(tr1 = 10))
# Generate genotype simulation parameters
SP <- param.geno(SP = SP, pop.marker = 1e4, pop.ind = 1e2)
# Generate phenotype simulation parameters
SP <- param.pheno(SP = SP, pop.ind = 100)
# Generate selection parameters
SP <- param.sel(SP = SP, sel.single = "ind")
# Generate reproduction parameters
SP <- param.reprod(SP = SP, reprod.way = "backcro")

# Run annotation simulation
SP <- annotation(SP)
# Run genotype simulation
SP <- genotype(SP)
# Run phenotype simulation
SP <- phenotype(SP)
# Two different breeds are cut by sex
SP$pheno$pop$gen1$sex <- rep(c(1, 2), c(50, 50))
# Run selection
SP <- selects(SP)
# Run back cross
SP <- mate.backcro(SP)
}
}
\author{
Dong Yin
}
