% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Reproduces.r
\name{IndPerGen}
\alias{IndPerGen}
\title{Individual number per generation}
\usage{
IndPerGen(
  pop,
  pop.gen = 2,
  ps = c(0.8, 0.8),
  reprod.way = "randmate",
  sex.rate = 0.5,
  prog = 2
)
}
\arguments{
\item{pop}{the population information containing environmental factors and other effects.}

\item{pop.gen}{the generations of simulated population.}

\item{ps}{if ps <= 1, fraction selected in selection of males and females; if ps > 1, ps is number of selected males and females.}

\item{reprod.way}{reproduction method, it consists of 'clone', 'dh', 'selfpol', 'randmate', 'randexself', 'assort', 'disassort', '2waycro', '3waycro', '4waycro', 'backcro', and 'userped'.}

\item{sex.rate}{the sex ratio of simulated population.}

\item{prog}{the progeny number of an individual.}
}
\value{
the vector containing the individual number per generation.
}
\description{
Calculate the individual number per generation.
}
\details{
Build date: Apr 12, 2022
Last update: Apr 30, 2022
}
\examples{
pop <- generate.pop(pop.ind = 100)
count.ind <- IndPerGen(pop)
}
\author{
Dong Yin
}
