% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_subject_attributes}
\alias{sim_subject_attributes}
\title{Simulate Subject Latent Attribute Profiles \eqn{\mathbf{\alpha}_c}}
\usage{
sim_subject_attributes(N, K, probs = NULL)
}
\arguments{
\item{N}{Number of Observations}

\item{K}{Number of Skills}

\item{probs}{A \code{vector} of probabilities that sum to 1.}
}
\value{
A \eqn{N} by \eqn{K} \code{matrix} of latent classes
corresponding to entry \eqn{c} of \eqn{pi} based upon
mastery and nonmastery of the \eqn{K} skills.
}
\description{
Generate a sample from the
\eqn{\mathbf{\alpha}_c = (\alpha_{c1}, \ldots, \alpha_{cK})'}
attribute profile matrix for members of class \eqn{c} such that \eqn{\alpha_{ck}}
is 1 if members of class \eqn{c} possess skill \eqn{k} and zero otherwise.
}
\examples{
# Define number of subjects and attributes
N = 100
K = 3

# Generate a sample from the Latent Attribute Profile (Alpha) Matrix
# By default, we sample from a uniform distribution weighting of classes.
alphas_builtin = sim_subject_attributes(N, K)

# Generate a sample using custom probabilities from the
# Latent Attribute Profile (Alpha) Matrix
probs = rep(1 / (2 ^ K), 2 ^ K)
alphas_custom = sim_subject_attributes(N, K, probs)
}
\seealso{
\code{\link[simcdm:sim_attribute_classes]{simcdm::sim_attribute_classes()}} and \code{\link[simcdm:attribute_inv_bijection]{simcdm::attribute_inv_bijection()}}
}
\author{
James Joseph Balamuta and Steven Andrew Culpepper
}
