% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep_plot.R
\name{plot_study}
\alias{plot_study}
\title{Plot ae development of study and sites highlighting at risk sites.}
\usage{
plot_study(
  df_visit,
  df_site,
  df_eval,
  study,
  df_al = NULL,
  n_sites = 16,
  pval = FALSE
)
}
\arguments{
\item{df_visit}{dataframe, created by \code{\link[=sim_sites]{sim_sites()}}}

\item{df_site}{dataframe created by \code{\link[=site_aggr]{site_aggr()}}}

\item{df_eval}{dataframe created by \code{\link[=eval_sites]{eval_sites()}}}

\item{study}{study}

\item{df_al}{dataframe containing study_id, site_number, alert_level_site,
alert_level_study (optional), Default: NA}

\item{n_sites}{integer number of most at risk sites, Default: 16}

\item{pval}{logical show p-value, Default:FALSE}
}
\value{
ggplot
}
\description{
Most suitable visual representation of the AE under-reporting statistics.
}
\details{
Left panel shows mean AE reporting per site (lightblue and darkblue
lines) against mean AE reporting of the entire study (golden line). Single
sites are plotted in descending order by AE under-reporting probability on
the right panel in which grey lines denote cumulative AE count of single
patients. Grey dots in the left panel plot indicate sites that were picked
for single plotting. AE under-reporting probability of dark blue lines
crossed threshold of 95\%. Numbers in the upper left corner indicate the
ratio of patients that have been used for the analysis against the total
number of patients. Patients that have not been on the study long enough to
reach the evaluation point (visit_med75) will be ignored.
}
\examples{
\donttest{
df_visit <- sim_test_data_study(n_pat = 1000, n_sites = 10,
    frac_site_with_ur = 0.2, ur_rate = 0.15, max_visit_sd = 8)

df_visit$study_id <- "A"
df_site <- site_aggr(df_visit)

df_sim_sites <- sim_sites(df_site, df_visit, r = 100)

df_eval <- eval_sites(df_sim_sites)

plot_study(df_visit, df_site, df_eval, study = "A")
}
}
