% Generated by roxygen2 (4.0.1): do not edit by hand
\name{as.data.frame.evalGrid}
\alias{as.data.frame.evalGrid}
\title{Converts an \code{evalGrid} object into a \code{data.frame}}
\usage{
\method{as.data.frame}{evalGrid}(x, ..., convert.result.fun = identity,
  summary.fun = NULL, progress = FALSE)
}
\arguments{
\item{x}{an object returned by
\code{\link{evalGrids}}}

\item{\dots}{only for S3 method consistency}

\item{convert.result.fun}{a functions that converts the result
object contained in \code{x} into a \code{data.frame}}

\item{summary.fun}{univariate functions to summarize the results (numeric or logical) over
the replications, e.g. mean, sd. Alternatively, \code{summary.fun} can be one
function that may return a vector.}

\item{progress}{if \code{TRUE} a progress bar is shown in the console.}
}
\value{
a \code{data.frame} with the parameter constellations
 for the data generation and evaluation and the results
 (probably summarized).
}
\description{
Converts the results contained in the
 object returned by \code{\link{evalGrids}}
 into a \code{data.frame}. If the results can not
 be coerced automatically into a \code{data.frame}, the
 user can provide a function to pre-process the
 results (see \code{convert.result.fun}). Furthermore,
 univariate functions to summarize the results over
 the replications can be specified via \code{summary.fun}.
}
\examples{
genRegData <- function(){
 data.frame(
     x = 1:10,
     y = rnorm(10, mean=1:10))
}

eg <- evalGrids(
 expandGrid(fun="genRegData"),
 expandGrid(proc="lm", formula=c("y ~ x", "y ~ x + I(x^2)")),
 replications=5)

lm2df = function(lm.object) {
 ret = coef(summary.lm(lm.object))[, 1:2]
 data.frame(covariable = rownames(ret), ret, check.names=FALSE)
}
as.data.frame(eg, convert.result.fun=lm2df, progress=TRUE)
as.data.frame(eg, convert.result.fun=lm2df, summary.fun=c(mean, sd), progress=TRUE)
}
\author{
Marsel Scheer
}
\seealso{
\code{\link{evalGrids}}
}

