% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_function.R
\name{plotCorGraph}
\alias{plotCorGraph}
\title{Plot correlation or partial correlation matrix}
\usage{
plotCorGraph(S1, type = "cor", S2 = NULL, graph = NULL, path = NULL,
  main = "", colLim = c(-1, 1), legendColor = TRUE)
}
\arguments{
\item{S1, S2}{Sample covariance matrix. If \code{S2} supplied, the difference between the two corresponding correlation or partial correlation matrices is plotted.}

\item{type}{Character string specifying which matrix is to be plotted. Either \code{cor} for correlation matrix, or \code{pcor} for partial correlation matrix.}

\item{graph}{A graphNEL object.}

\item{path}{A list of edges in edgesList format (see \pkg{gRbase}).}

\item{main}{The main title.}

\item{colLim}{Numeric vector of length two specifying the lower and upper bound of the color range (see Details).}

\item{legendColor}{Logical value indicating whether the color legend should be added to the plot.}
}
\value{
Correlation or partial correlation matrix plot.
}
\description{
Plot a correlation or partial correlation matrix with the possibility to emphasize the graphical structure.
}
\details{
If the \code{graph} is supplied, the zero elements of the adjacency matrix are represented as shaded squares, whereas non-zero elements are represented as squares with grey borderline. \cr \cr
Admissible values for \code{colLim} are contained in the interval \code{[-1,1]} when \code{S2=NULL}, otherwise the admissible interval is \code{[-2,2]}.
When an element is outside of the \code{colLim} interval, it is colored gray.
}
\examples{
if( require(gRbase) & require(graph)){
 graph <- gRbase::ug(~a:b, ~a:c, ~c:d, ~b:d, ~b:c)

 S <- matrix(c(2,  0.8,0.5,-0.3,
              0.8,1.5,0.6,-0.7,
              0.5,0.6,1,  0.7,
              -0.3,-0.7,0.7,3), ncol=4,nrow=4)
 colnames(S) <- rownames(S) <- graph::nodes(graph)

 # Plot the correlation matrix of S
 plotCorGraph(S)


 S<-fitSgraph(graph = graph,S = S)
 # Change the color range
 plotCorGraph(S, colLim=c(-0.5,0.5))

 # Visualize the adjacency matrix
 plotCorGraph(S, type="cor", graph = graph)

 # Show the partial correlation matrix
 plotCorGraph(S, type="pcor", graph = graph)

 # Plot the difference between two matrices
 S2 <- S
 # Change the element c~a
 S2["a","c"] <- S2["c","a"]<- -0.1
 plotCorGraph(S1=S, S2=S2)
 plotCorGraph(S1=S, S2=S2, type="pcor")

 S2<-fitSgraph(graph = graph,S = S2)
 # Highlight the graphical structure
 plotCorGraph(S1=S, S2=S2, type="pcor",graph = graph)
 # Highlight the element c~a
 plotCorGraph(S1=S, S2=S2, type="pcor",graph = graph,path = list(c("a","c")))

}
}

