% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{areaCrit}
\alias{areaCrit}
\title{Critical area}
\usage{
areaCrit(vickers, stress, factor = 1.56, scale = 1e+06)
}
\arguments{
\item{vickers}{specific Vickers hardness}

\item{stress}{stress level}

\item{factor}{specific material dependent factor, default set to \code{1.56} for inner defects}

\item{scale}{area in square millimeters (default)}
}
\value{
critical area in \eqn{[mm]^2} (default)
}
\description{
Calculate critical area
}
\details{
The critical area (see reference below) is roughly defined by the projected defect area
above which the specific material defect becomes particularly hazardous for the failure
of the whole specimen.
}
\references{
Y. Murakami (2002). Metal Fatigue: Effects of Small Defects and Nonmetallic Inclusions. Elsevier, Amsterdam.
}
\author{
M. Baaske
}
