% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{simParticle}
\alias{simParticle}
\title{Simulate particle system (primary phase)}
\usage{
simParticle(theta, lam, box, mu = c(0, 1, 0), verbose = FALSE)
}
\arguments{
\item{theta}{simulation parameter list}

\item{lam}{intensity parameter of the underlying Poisson point process}

\item{box}{the simulation box}

\item{mu}{reference direction of particles, here \code{mu=c(0,1,0)} (default)}

\item{verbose}{logical, not used yet}
}
\value{
list of spheroids
}
\description{
Poisson spheroid system
}
\details{
The function generates a constant size Poisson spheroid system with intensity parameter \code{lam}
and random planar (with respect to the xz plane) orientation distribution. The spheroids are labeled
by \eqn{P} to denote the primary particle phase which usually plays the role of some reinforcement
material type in real life specimen. In order to simulate the fatigue lifetime model, see \code{\link{simDefect}},
a non-overlapping configuration of particles is required which could be generated for instance by application of
the the well-known random sequential adsorption (RSA) method, see \code{\link{rsa}}. Alternatively the Force-biased
algorithm could be used as well, see reference below.
}
\references{
\itemize{
				  \item{}{A. Bezrukov and D. Stoyan. Simulation and statistical analysis of random packings of ellipsoids. Particle & Particle Systems Characterization, 23(5):388 - 398, 2006.}
				  \item{}{J.W. Evans. Random and cooperative sequential adsorption. Rev. Mod. Phys., 65: 1281-1304. 1993.}
				}
}
\seealso{
\code{\link{simSpheroidSystem}}
}

