% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season_model_functions.R
\name{fit_model_default}
\alias{fit_model_default}
\title{Default ITS model}
\usage{
fit_model_default(dat, outcomename, lagless = FALSE, ...)
}
\arguments{
\item{dat}{Dataframe of pre-policy data to fit model to.  Needs a "month" column}

\item{outcomename}{Outcome of interest}

\item{lagless}{Boolean, include the lagged outcome, or not?}

\item{...}{Extra arguments passed to the lm() call.}
}
\value{
A fit model (a `lm` object from a `lm()` call) from fitting a simple
  regression of outcome onto month and lagged month.
}
\description{
This fits the model `outcomename ~ lag.outcome + month`, with no
covariates.
}
\examples{
mecklenberg = add_lagged_covariates(mecklenberg, "pbail")
meck.pre = filter( mecklenberg, month <= 0 )
mod = fit_model_default( meck.pre, "pbail", lagless = TRUE )
summary( mod )
mod = fit_model_default( meck.pre, "pbail", lagless = FALSE )
summary( mod )
}
