% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventTracking.R
\name{censoringByNumberEvents}
\alias{censoringByNumberEvents}
\title{Event-driven censoring.}
\usage{
censoringByNumberEvents(data, eventNum, typeEvent)
}
\arguments{
\item{data}{(\code{data.frame})\cr illness-death data set in \verb{1rowPatient} format.}

\item{eventNum}{(\code{int})\cr number of events.}

\item{typeEvent}{(\code{string})\cr type of event. Possible values are \code{PFS} and \code{OS}.}
}
\value{
This function returns a data set that is censored after \code{eventNum} of
\code{typeEvent}-events occurred.
}
\description{
This function censors a study after a pre-specified number of events occurred.
}
\examples{
transition1 <- weibull_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6, p01 = 0.8, p02 = 0.9, p12 = 1)
transition2 <- weibull_transition(h01 = 1, h02 = 1.3, h12 = 1.7, p01 = 1.1, p02 = 0.9, p12 = 1.1)

simStudy <- getOneClinicalTrial(
  nPat = c(20, 20), transitionByArm = list(transition1, transition2),
  dropout = list(rate = 0.3, time = 10),
  accrual = list(param = "time", value = 7)
)
simStudyWide <- getDatasetWideFormat(simStudy)
censoringByNumberEvents(data = simStudyWide, eventNum = 20, typeEvent = "PFS")
}
