% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_DualKc.R
\name{cal_Kr_for_DualKc}
\alias{cal_Kr_for_DualKc}
\title{Dimensionless evaporation reduction coefficient}
\usage{
cal_Kr_for_DualKc(TEW, REW, De)
}
\arguments{
\item{TEW}{maximum cumulative depth of evaporation (depletion) from
the soil surface layer when Kr = 0 (TEW = total evaporable water)}

\item{REW}{cumulative depth of evaporation (depletion) at the end of stage 1
(REW = readily evaporable water), mm}

\item{De}{cumulative depth of evaporation (depletion) from the soil surface
layer at the end of day i-1 (the previous day),mm}
}
\value{
A value for evaporation reduction coefficient
}
\description{
It dependent on the soil water depletion
   (cumulative depth of evaporation) from the topsoil
   layer (Kr = 1 when De,i-1 is equal or lesser than REW)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
