% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomTest.R
\name{render.sigr_binomtest}
\alias{render.sigr_binomtest}
\title{Format binom.test (test of rate of a Bernoulli experiment).}
\usage{
\method{render}{sigr_binomtest}(statistic, ..., format, statDigits = 4,
  sigDigits = 4, pLargeCutoff = 0.05, pSmallCutoff = 1e-05)
}
\arguments{
\item{statistic}{wrapped binom.test.}

\item{...}{extra arguments (not used)}

\item{format}{if set the format to return ("html", "latex", "markdown", "ascii", "docx", ...)}

\item{statDigits}{integer number of digits to show in summaries.}

\item{sigDigits}{integer number of digits to show in significances.}

\item{pLargeCutoff}{value to declare non-significance at or above.}

\item{pSmallCutoff}{smallest value to print}
}
\value{
formatted string
}
\description{
Format binom.test (test of rate of a Bernoulli experiment).
}
\examples{

bt <- binom.test(7, 10, 0.5)
wrapBinomTest(bt)


}
