% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{scoring}
\alias{scoring}
\title{Score Copy Number Profile}
\usage{
scoring(object, TD_size_cutoff = c(1000, 100000, 2000000), TD_cn_cutoff = Inf)
}
\arguments{
\item{object}{a object of \link{CopyNumber}.}

\item{TD_size_cutoff}{a length-3 numeric vector used to specify the start, midpoint, end
segment size for determining tandem duplication size range, midpoint is used to split
TD into short TD and long TD. Default is 1Kb to 100Kb for short TD, 100Kb to 2Mb for long
TD.}

\item{TD_cn_cutoff}{a number defining the maximum copy number of TD,
default is \code{Inf}, i.e. no cutoff.}
}
\value{
a \code{data.table} with following scores:
\itemize{
\item cnaBurden: CNA burden representing the altered genomic fraction as previously reported.
\item cnaLoad: CNA load representing the quantity of copy number alteration.
\item MACN: mean altered copy number (MACN) reflecting the property of altered copy number segments,
calculated as
\deqn{MACN = \frac{\sum_{i} CN_i}{N_{cnv}}}
where \eqn{CN_i} is the copy number of altered segment \eqn{i}, \eqn{N_{cnv}} is
the number of CNV.
\item weightedMACN: same as MACN but weighted with segment length.
\deqn{MACN_{weighted} = \frac{\sum_{i} (CN_i \times L_{i})}{ \sum_{i} L_{i} }}
where \eqn{L_{i}} is the length of altered copy number segment \eqn{i}.
\item Ploidy: ploidy, the formula is same as \code{weightedMACN} but using all copy number segments instead of
altered copy number segments.
\item TDP_pnas: tandem duplication phenotype score from \url{https://www.pnas.org/doi/10.1073/pnas.1520010113},
the threshold \code{k} in reference is omitted.
\deqn{TDP = - \frac{\sum_{chr} |TD_{obs}-TD_{exp}|}{TD_{total}}}
where \eqn{TD_{total}} is the number of TD, \eqn{TD_{obs}} and
\eqn{TD_exp} are observed number of TD and expected number of TD for each chromosome.
\item TDP: tandem duplication score used defined by our group work,
TD represents segment with copy number greater than 2.
\deqn{TD = \frac{TD_{total}}{\sum_{chr} |TD_{obs}-TD_{exp}|+1}}
\item sTDP: TDP score for short TD.
\item lTDP: TDP score for long TD.
\item TDP_size : TDP region size (Mb).
\item sTDP_size: sTDP region size (Mb).
\item lTDP_size: lTDP region size(Mb).
\item Chromoth_state: chromothripsis state score,
according to reference \doi{10.1016/j.cell.2013.02.023},
chromothripsis frequently leads to massive loss of segments on
the affected chromosome with segmental losses being interspersed with regions displaying
normal (disomic) copy-number (e.g., copy-number states oscillating between
copy-number = 1 and copy-number = 2), form tens to hundreds of locally clustered DNA rearrangements.
Most of methods use both SV and CNV to infer chromothripsis, here we roughly quantify it with
\deqn{\sum_{chr}{N_{OsCN}^2}}
where \eqn{N_{OsCN}} is the number of oscillating copy number pattern "2-1-2" for each chromosome.
}
}
\description{
Returns quantification of copy number profile and events including
tandem duplication and Chromothripisis etc.
Only copy number data from autosome is used here.
\strong{Some of the quantification methods are rough,
you use at your risk}. You should do some extra work to check the
result scores.
}
\examples{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))

d <- scoring(cn)
d

d2 <- scoring(cn, TD_cn_cutoff = 4L)
d2
}
